if (window._cb === undefined) {
	var Vera = (function(window, undefined) {
		let dataLayer = window.dataLayer || [];
		let baseUrl = window._cbParams.base_url;
		let timeout = window._cbParams.timeout || 10000;
		let apiUrl = baseUrl + '/api';
		let params = {};
		let callVeraStart = false;
		let Vera = {};

		let userId = window._cbParams.user_id;
		let app = window._cbParams.client_id;
		let region = window._cbParams.region;

		let options = {};

		if (MediaRecorder.isTypeSupported('audio/webm; codecs=opus')) {
			options = {mimeType: 'audio/webm; codecs=opus', audioBitsPerSecond: 16000};
		} else if (MediaRecorder.isTypeSupported('audio/mp4')) {
			options = {mimeType: 'audio/mp4', audioBitsPerSecond: 16000};
		} else {
			console.error("no suitable mimetype found for this device");
		}

		let mediaRecorder = null;

		let wavesurfers = [];
		let wsuId = 1;
		let ws_chatbot = null;

		Vera.loadChatWindow = function() {

			dataLayer.push({
				'event': 'chatbot-display'
			});

			let chatWindowNode = document.createElement('div');
			chatWindowNode.innerHTML = `
					<div id="open-chatbot" class="enabled"></div>
					<div id="open-chatbot-message">
						<a id="chatbot-message-close" href="#"><span class="close-icon"></span></a>
						<p>
							Guten Tag!<br />Ich bin der Chatbot der WKO.<br />Wie kann ich Ihnen helfen?
						</p>
					</div>
					<div id="close-chatbot" style="display: none;"></div>
					<div id="chatbot-window" class=""></div>
				`;

			document.getElementsByTagName('body')[0].appendChild(chatWindowNode);
			Vera.jq.ajax({
				method: 'GET',
				url: baseUrl + '/chat-window',
				contentType: 'text/html',
				xhrFields: {
					withCredentials: true
				},
				crossDomain: true,
				success: function (data) {
					Vera.jq("#chatbot-window").html(data);
					Vera.initChatWindow();
				}
			});
		}
		Vera.initChatWindow = function() {
			Vera.jq('#open-chatbot').click(function() {
				dataLayer.push({
					'event': 'chatbot-open'
				});
				if(callVeraStart){
					var message = {
						'type': 'text',
						'text': 'vera_start'
					}
					Vera.ask(message, 'vera_start');
					callVeraStart = false;
				}else{
					let $chatBody = Vera.jq('.chatbot-chat-history');
					$chatBody.scrollTop($chatBody.prop("scrollHeight"));
				}

				Vera.jq('#chatbot-window').addClass('open');
				Vera.jq('#open-chatbot').hide();
				Vera.jq('#close-chatbot').show();
				Vera.jq('#open-chatbot-message').hide();

				
			});


			Vera.jq('#close-chatbot, .close-icon').click(function() {

				if(ws_chatbot != null) {
					ws_chatbot.destroy();
				}
				
				Vera.jq('#cancel-audio-message').trigger('click');

				wavesurfers.forEach(function(waversurfer, index) {
					if(waversurfer && typeof waversurfer.destroy === 'function'){
						waversurfer.stop();
						let $playbackBtn = Vera.jq('#wavesurfer-' + index).siblings('.playback-button');
						if($playbackBtn.hasClass('pause')){
							$playbackBtn.removeClass('pause').addClass('play');
						}
					}
				});

				Vera.jq('.text-audio-message.playing').removeClass('playing');

				Vera.jq('#chatbot-window').removeClass('open');
				Vera.jq('#open-chatbot').show();
				Vera.jq('#close-chatbot').hide();
			});

			Vera.jq('#chatbot-message-close').click(function(e) {
				e.preventDefault();
				e.stopPropagation();
				Vera.jq('#open-chatbot-message').hide();
			});

			if(parseInt(window.sessionStorage.getItem("openChatbot")) !== 1 && parseInt(window.sessionStorage.getItem("openMessageAlreadyShown")) !== 1){
				setTimeout(function() {
					Vera.jq('#open-chatbot-message').addClass('active');
					window.sessionStorage.setItem("openMessageAlreadyShown", 1);
				}, 2000);
			}

			Vera.applySizeClass();

			Vera.jq(window).resize(function() {
				Vera.applySizeClass();
			});


			Vera.jq.ajax({
				method: 'GET',
				url: apiUrl + '/load-session-history',
				contentType: 'text/html',
				xhrFields: {
					withCredentials: true
				},
				crossDomain: true,
				success: function (data) {
					if(data.length > 0){
						data.forEach(function(element) {
							audioVal = Object.values(element.userMessage)[0]?.audioFile ?? null;
							fileSavedVal = Object.values(element.userMessage)[0]?.file_saved ?? 0;

							if(audioVal && fileSavedVal) {
								let audioHTML = `<div class="audio-playback"><span class="playback-button play"></span><div class="ws-audio" id="wavesurfer-${wsuId}" data-href="${baseUrl}/${audioVal}"></div></div>`;
								Vera.showMessages([{ 'type': 'text', 'text': audioHTML }], true);

								wavesurfers[wsuId] = Vera.ws.create({
									container: '#wavesurfer-' + wsuId,
									url: `${baseUrl}/${audioVal}`,
									height: 60,
									width: 200,
									splitChannels: false,
									waveColor: '#AAA',
									progressColor: '#000',
									cursorColor: '#000',
									cursorWidth: 2,
									barWidth: 4,
									barGap: 2,
									barRadius: 10,
									mediaControls: false,
									interact: true,
									audioRate: 1,
									autoScroll: true,
									autoCenter: true,
									sampleRate: 48000,
								});
								wsuId++;
							} else {
								// Hier würde auch die Audio Transcription ausgegeben werden --> wenn benötigt: über dem if ausgeben
								Vera.showMessages(element.userMessage, true, 0, '', false, "global", false);
							}
							Vera.showMessages(element.answers, false, element.id, element.feedback, false, element.region, false);
						});
					}else{
						callVeraStart = true;
					}
					Vera.initChat();
					if(parseInt(window.sessionStorage.getItem("openChatbot")) === 1){
						Vera.jq('#open-chatbot').click();
						window.sessionStorage.removeItem("openChatbot")
					}
				}
			});
		}

		Vera.applySizeClass = function () {
			let width = Vera.jq(window).innerWidth();
			let height = Vera.jq(window).innerHeight();

			if(width >= 768) {
				Vera.jq('#chatbot-window').addClass('desktop');
			} else {
				Vera.jq('#chatbot-window').removeClass('desktop');
			}
		}

		Vera.initChat = function() {

			Vera.jq('#send-user-message').click(function(e) {
				e.preventDefault();
				e.stopPropagation();

				var $messageInput = Vera.jq('#user-message-input');
				var textMessage = Vera.jq.trim($messageInput.text());

				if (textMessage && textMessage.length > 0) {
					var message = {
						'type': 'text',
						'text': Vera.escapeMessage(textMessage)
					}
					Vera.ask(message, '');

					$messageInput.text('').focus();
				}
			});

			Vera.jq('#audio-input-message').click(function(e) {
				e.preventDefault();
				e.stopPropagation();

				if(ws_chatbot != null){
					ws_chatbot.destroy();
				}

				Vera.jq('.text-audio-message.playing').removeClass('playing');

				let cancelTimeout;
				let canceled = false;
				var isPaused = false;

				Vera.jq('#send-audio-message, #cancel-audio-message').off('click');

				navigator.mediaDevices.getUserMedia({ audio: true })
					.then(function(stream) {
						const mediaRecorder = new MediaRecorder(stream, options);
						const audioChunks = [];

						mediaRecorder.start();

						Vera.jq('.chatbot-message-input').hide();
						Vera.jq('.chatbot-audio-container').css('display', 'flex');

						let startTime = new Date().getTime();
						let recordingTime = setInterval(function() {
							if(!isPaused) {
								let currentTime = new Date().getTime();
								let elapsedTime = currentTime - startTime;
								let seconds = Math.floor(elapsedTime / 1000) % 60;
								let minutes = Math.floor(elapsedTime / 1000 / 60) % 60;

								Vera.jq('.chatbot-audio-container .audio-duration').html(minutes + ":" + ((seconds < 10 ? "0" : "") + seconds));
							}
						}, 1000);

						mediaRecorder.addEventListener("dataavailable", function(event) {
							audioChunks.push(event.data);
						});

						Vera.jq('#send-audio-message').on('click', function() {
							e.preventDefault();
							e.stopPropagation();
							mediaRecorder.stop();
						});

						Vera.jq('#cancel-audio-message').on('click', function() {
							e.preventDefault();
							e.stopPropagation();

							clearTimeout(cancelTimeout);
							mediaRecorder.stop();
							canceled = true;
						});

						mediaRecorder.addEventListener("start", function() {

							cancelTimeout = setTimeout(() => {
								if (!canceled) {
									isPaused = true;
									mediaRecorder.pause();
									let errorMessageHtml = `<div class="chatbot-messageC chatbot-audio-error">
																				<div class="audio-error">
																					<span class="audio-error-icon"></span>
																					<span class="audio-error-message">
																						Aufnahmezeit überschritten. Bitte halten Sie Spracheingaben unter 30 Sekunden.
																					</span>
																				</div>
																			</div>`;
									Vera.jq('.chatbot-chat-history').append(errorMessageHtml);
								}
							}, 30000);
						});

						mediaRecorder.addEventListener("stop", function() {
							clearTimeout(cancelTimeout); // Clear timeout on stop
							clearInterval(recordingTime);

							Vera.jq('.chatbot-audio-container .audio-duration').html('0:00');
							Vera.jq('.chatbot-audio-container').css('display', 'none');
							Vera.jq('.chatbot-message-input').show();


							let audioBlob = {};

							if (MediaRecorder.isTypeSupported('audio/webm; codecs=opus')) {
								audioBlob = new Blob(audioChunks, { type: 'audio/webm; codecs=opus' });
							} else if (MediaRecorder.isTypeSupported('audio/mp4')) {
								audioBlob = new Blob(audioChunks, { type: 'audio/mp4' });
							}

							const formData = new FormData();

							formData.append('audio', audioBlob);

							mediaRecorder.stream.getAudioTracks().forEach(function(track){track.stop();});

							if(!canceled) {

								let loadingMessage = `<div class="chatbot-messageC chatbot-audio-loading">
															<div class="loading-container">
																<span class="audio-loading"></span>
															</div>
														</div>`;

								Vera.jq('.chatbot-chat-history').append(loadingMessage);

								Vera.jq.ajax({
									url: apiUrl + '/speech-to-text',
									type: 'POST',
									data: formData,
									contentType: false,
									processData: false,
									headers: {
										'X-CSRF-TOKEN': Vera.jq('#chat-input').find('[name=\'_token\']').first().val()
									},
									dataType: 'json',
									xhrFields: {
										withCredentials: true
									},
									crossDomain: true,
									success: function(response) {
										Vera.jq('.chatbot-audio-loading').remove();
										if (response.transcription) {
											let $fileSaved = Vera.jq('#audio-available');
											let $messageInput = Vera.jq('#user-message-input');
											let $audio = Vera.jq('#audio');

											$fileSaved.val(response.fileSaved)
											$messageInput.text(response.transcription)
											$audio.val(response.audioUrl)

											Vera.jq('#send-user-message').trigger('click')
										} else {
											let errorMessageHtml = `<div class="chatbot-messageC chatbot-audio-error">
																				<div class="audio-error">
																					<span class="audio-error-icon"></span>
																					<span class="audio-error-message">
																						${response.error}
																					</span>
																				</div>
																			</div>`;
											Vera.jq('.chatbot-chat-history').append(errorMessageHtml);
										}

									},
									error: function(xhr, status, error) {
										Vera.jq('.chatbot-audio-loading').remove();
										if(xhr.status === 419){
											Vera.updateCsrf(message, event)
										}

										let err = xhr.error || `Ein unbekannter Fehler ist aufgetreten. Bitte Versuchen sie es in einigen Minuten noch einmal.`;
										let errorMessageHtml = `<div class="chatbot-messageC chatbot-audio-error">
																				<div class="audio-error">
																					<span class="audio-error-icon"></span>
																					<span class="audio-error-message">
																						${err}
																					</span>
																				</div>
																			</div>`;
										Vera.jq('.chatbot-chat-history').append(errorMessageHtml);
									}
								});
							}
						});
					})
					.catch(function(error) {
						console.log(error);
						let errorMessageHtml = `<div class="chatbot-messageC chatbot-audio-error">
																				<div class="audio-error">
																					<span class="audio-error-icon"></span>
																					<span class="audio-error-message">
																						Zugriff auf Mikrofon verweigert. Bitte erlauben Sie den Zugriff in den Einstellungen Ihres Geräts.
																					</span>
																				</div>
																			</div>`;
						Vera.jq('.chatbot-chat-history').append(errorMessageHtml);
						Vera.jq('.chatbot-audio-container').css('display', 'none');
						Vera.jq('.chatbot-message-input').show();
					});
			});

			Vera.jq(document).on('click', '.text-audio-message:not(.playing)', function(e) {
				e.preventDefault();
				e.stopPropagation();

				Vera.jq('#cancel-audio-message').trigger('click');

				if(ws_chatbot != null) {
					ws_chatbot.destroy();
				}

				wavesurfers.forEach(function(wavesurfer, index) {
					if(wavesurfer && typeof wavesurfer.stop === 'function') {
						wavesurfer.stop();
						let $playbackBtn = Vera.jq('#wavesurfer-' + index).siblings('.playback-button');
						if($playbackBtn.hasClass('pause')){
							$playbackBtn.removeClass('pause').addClass('play');
						}
					}
				});

				Vera.jq('.text-audio-message').removeClass('playing');

				let $buttonElem = Vera.jq(this);
				$buttonElem.addClass('loading');

				var textMessage = '';
				var $textAudioMessage = Vera.jq(this);
				var $chatMessageContainer = $textAudioMessage.parents('.chatbot-messageC.chatbot-responseC').first();

				$chatMessageContainer.find('.chatbot-chat-message').each(function() {
					var messageText = Vera.jq(this).text().trim();
					textMessage += messageText + ' ';
				});

				$chatMessageContainer.find('.chatbot-quick-reply').each(function() {
					var quickReplyText = Vera.jq(this).text().trim();
					textMessage += quickReplyText + '. ';
				});

				textMessage = textMessage.trim();
				textMessage = $chatMessageContainer.html().trim();

				if (textMessage.length > 0) {
					Vera.jq.ajax({
						headers: {
							'X-CSRF-TOKEN': Vera.jq('#chat-input').find('[name=\'_token\']').first().val()
						},
						method: 'POST',
						url: apiUrl + '/text-to-speech',
						data: JSON.stringify({
							textinput: textMessage,
							device: (/Mobi|Android/i.test(navigator.userAgent) ? "mobile" : "desktop"),
							id: $buttonElem.data('id'),
							user_id: userId,
							app: app,
							region: region
						}),
						dataType: 'json',
						contentType: 'application/json',
						xhrFields: {
							withCredentials: true
						},
						crossDomain: true,
						success: function(response) {
							if (response.audioContent) {
								var audio = new Audio("data:audio/mp3;base64," + response.audioContent);

								if(ws_chatbot != null) {
									ws_chatbot.destroy();
								}

								$buttonElem.parent().append('<div class="ws-audio" id="wavesurferCB"></div>')

								ws_chatbot = Vera.ws.create({
									container: '#wavesurferCB',
									media: audio,
									height: 20,
									width: 200,
									splitChannels: false,
									waveColor: '#AAA',
									progressColor: '#000',
									cursorColor: '#000',
									cursorWidth: 2,
									barWidth: 4,
									barGap: 2,
									barRadius: 10,
									mediaControls: false,
									interact: true,
									audioRate: 1,
									autoScroll: true,
									autoCenter: true,
									sampleRate: 48000,
								});

								ws_chatbot.playPause();
								$buttonElem.removeClass('loading');
								$buttonElem.addClass('playing');

								ws_chatbot.on('finish', () => {
									ws_chatbot.destroy();
								});

								ws_chatbot.on('destroy', () => {
									$buttonElem.removeClass('playing');
									$buttonElem.parent().find('#wavesurferCB').remove();
								});

								//audio.play();

								Vera.jq(document).on('click', '.text-audio-message.playing', function(e) {
									e.preventDefault();
									e.stopPropagation();
									//audio.pause();
									ws_chatbot.destroy();
								});

								audio.addEventListener("ended", (event) => {
									$buttonElem.removeClass('playing');
								});

							} else {
								let errorMessageHtml = `<div class="chatbot-messageC chatbot-audio-error">
																				<div class="audio-error">
																					<span class="audio-error-icon"></span>
																					<span class="audio-error-message">
																						${response.error}
																					</span>
																				</div>
																			</div>`;
								Vera.jq('.chatbot-chat-history').append(errorMessageHtml);
								$buttonElem.removeClass('loading');
							}
						},
						error: function(xhr, status, error) {
							$buttonElem.removeClass('loading');
							if(xhr.status === 419){
								Vera.updateCsrf(message, event)
							}
							let errorMessageHtml = `<div class="chatbot-messageC chatbot-audio-error">
																				<div class="audio-error">
																					<span class="audio-error-icon"></span>
																					<span class="audio-error-message">
																						Ein unbekannter Fehler ist aufgetreten. Bitte Versuchen sie es in einigen Minuten noch einmal.
																					</span>
																				</div>
																			</div>`;
							Vera.jq('.chatbot-chat-history').append(errorMessageHtml);
						}
					});
				} else {
					console.warn("No text input to synthesize.");
				}
			});

			Vera.jq(document).on('click', "#chatbot-window .chatbot-quick-reply-button:not(.chatbot-quick-reply-outline), #chatbot-window .chatbot-action-list-item", function(e){
				e.preventDefault();
				e.stopPropagation();
				var message = {
					'type': 'text',
					'text': Vera.escapeMessage(Vera.jq(this).data("query"))
				}
				Vera.ask(message,'');
			});

			Vera.jq(document).on('click', ".chatbot-quick-reply-outline", function(e){
				e.preventDefault();
				e.stopPropagation();
				Vera.jq(this).parents(".chatbot-response-quick-replies").find(".chatbot-quick-reply").show();
				Vera.jq(this).hide();
			});

			Vera.jq("#user-message-input").on('keypress',function(e) {
				if(e.which == 13) {
					e.preventDefault();
					Vera.jq("#send-user-message").click();
				}
			});

			Vera.jq(document).on('click', '.chatbot-feedback-icon-up', function(e){
				e.preventDefault();
				Vera.jq.ajax({
					headers: {
						'X-CSRF-TOKEN': Vera.jq('#chat-input').find('[name=\'_token\']').first().val()
					},
					method: 'POST',
					url: apiUrl + '/store-feedback',
					data: JSON.stringify({
						feedback: "positiv",
						message_id: Vera.jq(this).data("id")
					}),
					dataType: 'json',
					contentType: 'application/json',
					xhrFields: {
						withCredentials: true
					},
					crossDomain: true,
				});

				Vera.jq(this).addClass("active");
				Vera.jq(this).parent().find("span").addClass("disabled");

			});

			Vera.jq(document).on('click', '.chatbot-feedback-icon-down', function(e){
				e.preventDefault();
				Vera.jq.ajax({
					headers: {
						'X-CSRF-TOKEN': Vera.jq('#chat-input').find('[name=\'_token\']').first().val()
					},
					method: 'POST',
					url: apiUrl + '/store-feedback',
					data: JSON.stringify({
						feedback: "negativ",
						message_id: Vera.jq(this).data("id")
					}),
					dataType: 'json',
					contentType: 'application/json',
					xhrFields: {
						withCredentials: true
					},
					crossDomain: true,
				});

				Vera.jq(this).addClass("active");
				Vera.jq(this).parent().find("span").addClass("disabled");
				var message = {
					'type': 'text',
					'text': 'nein',
					'feedback_message': "<div class='feedbackmessage'><span class='chatbot-feedback-title'>Feedback zu:</span><div class='chatbot-feedback-body'>" + Vera.jq(this).parents(".chatbot-messageC").find(".chatbot-message-content").first().html() + "</div></div>"
				}
				Vera.ask(message, 'feedback_start');
			});

			Vera.jq(document).on("click", "#chatbot-window a[target!='_blank']:not(.chatbot-quick-reply-button,.chatbot-action-list-item)", function (e) {
				e.preventDefault();
				dataLayer.push({
					"event": "chatbot-link-click",
					"url": Vera.jq(this).attr("href")
				});
				if(Vera.jq(window).innerWidth() > 992) {
					window.sessionStorage.setItem("openChatbot", 1);
				}
				window.location.href = Vera.jq(this).attr("href");
			});

			Vera.jq(document).on("click", "#chatbot-window a[target='_blank']", function (e) {
				e.preventDefault();
				dataLayer.push({
					"event": "chatbot-link-click",
					"url": Vera.jq(this).attr("href")
				});
				window.open(Vera.jq(this).attr("href"), "_blank");
			});

			Vera.jq(document).on('click', '.playback-button', function() {
				let wsId = Vera.jq(this).siblings('.ws-audio').attr('id');
				let $playbackBtn = Vera.jq(this);

				if(ws_chatbot != null){
					ws_chatbot.destroy();
				}

				Vera.jq('.text-audio-message.playing').removeClass('playing');

				wavesurfers.forEach(function(wavesurfer, index) {
					if(wsId.split('-')[1] != index && wavesurfer && typeof wavesurfer.stop === 'function') {
						wavesurfer.stop();
						let $otherBtn = Vera.jq('#wavesurfer-' + index).siblings('.playback-button');
						if($otherBtn.hasClass('pause')){
							$otherBtn.removeClass('pause').addClass('play');
						}
					}
				});

				wavesurfers[wsId.split('-')[1]].unAll();
				wavesurfers[wsId.split('-')[1]].playPause();
				$playbackBtn.toggleClass('play').toggleClass('pause');

				wavesurfers[wsId.split('-')[1]].on('finish', () => {
					$playbackBtn.toggleClass('play').toggleClass('pause');
				});
			});
		}

		Vera.ask = function(message, event = '', hideUserMessage = false) {
			let $audio = Vera.jq('#audio');
			let $fileSaved = Vera.jq('#audio-available');
			let audioVal = $audio.val() ?? null;
			let fileSavedVal = $fileSaved.val();
			$audio.val(null)

			if (event === '') {
				if(!hideUserMessage){
					//User-Message anzeigen

					if(audioVal && parseInt(fileSavedVal)) {
						let audioHTML = `<div class="audio-playback"><span class="playback-button play"></span><div class="ws-audio" id="wavesurfer-${wsuId}" data-href="${baseUrl}/${audioVal}"></div></div>`;
						Vera.showMessages([{ 'type': 'text', 'text': audioHTML }], true);

						wavesurfers[wsuId] = Vera.ws.create({
							container: '#wavesurfer-' + wsuId,
							url: `${baseUrl}/${audioVal}`,
							height: 60,
							width: 200,
							splitChannels: false,
							waveColor: '#AAA',
							progressColor: '#000',
							cursorColor: '#000',
							cursorWidth: 2,
							barWidth: 4,
							barGap: 2,
							barRadius: 10,
							mediaControls: false,
							interact: true,
							audioRate: 1,
							autoScroll: true,
							autoCenter: true,
							sampleRate: 48000,
						});
						wsuId++;
					} else {
						// Hier würde auch die Audio Transcription ausgegeben werden --> wenn benötigt: über dem if ausgeben
						Vera.showMessages([message], true);
					}

					$fileSaved.val(null)
				}
			}

			let fb = "";
			if(message.hasOwnProperty('feedback_message')){
				fb = message.feedback_message
			}

			Vera.jq.ajax({
				headers: {
					'X-CSRF-TOKEN': Vera.jq('#chat-input').find('[name=\'_token\']').first().val()
				},
				method: 'POST',
				url: apiUrl + '/talk',
				data: JSON.stringify({
					event: event,
					message: message.text,
					feedbackMessage: fb,
					userId: userId,
					app: app,
					audio: audioVal,
					fileSaved: fileSavedVal,
					device: /Mobi|Android/i.test(navigator.userAgent) ? "mobile" : "desktop",
					region: region
				}),
				dataType: 'json',
				contentType: 'application/json',
				xhrFields: {
					withCredentials: true
				},
				crossDomain: true,
				success: function(data) {
					if (data.success !== -1) {
						if(data.answers.length === 0){
							var message = {
								'type': 'text',
								'text': 'no_answer'
							}
							Vera.ask(message, 'no_answer');
						}else{
							var returnedMessages= Vera.showMessages(data.answers, false, data.id);
							var $chatBody = Vera.jq('.chatbot-chat-history');
							var resultOffsetTop = 0;

							resultOffsetTop = $chatBody.prop("scrollHeight") - Vera.jq('.chatbot-responseC').last().innerHeight() - 50;

							$chatBody.animate({ scrollTop: resultOffsetTop  }, 200);
							
							if(audioVal && parseInt(fileSavedVal) && Vera.jq(window).innerWidth() < 768) {
								let $lastAudioButton = Vera.jq('.chatbot-responseC').last().find('.text-audio-message:not(.playing)');
								if($lastAudioButton.length > 0){
									$lastAudioButton.trigger('click');
								}
							}
						}
					}
				},
				error: function (jqXHR) {
					if(jqXHR.status === 419){//if you get 419 error which meantoken expired
						Vera.updateCsrf(message, event)
					}
				}
			});
		}

		Vera.showMessages = function(messages, isUserMessage, id = 0, feedback = '', showAnim = true, historyRegion = "global", isCurrent = true) {
			var returnedMessages = [];
			if(messages.length > 0){
				var textToSpeechElem = `<div class="chatbot-text-to-speech"><span href="#" class="text-audio-message" data-id="${id}"></span></div>`;
				var $messageContainer = Vera.jq('<div class="chatbot-messageC ' + (isUserMessage ? 'chatbot-user-message' : 'chatbot-responseC') + '">' + (isUserMessage ? '' : textToSpeechElem) + '</div>');
				var isFirstMessage = true;
				var isLastMessage = false;
				for (var i=0; i<messages.length; i++) {

					if(i === 0){
						isFirstMessage = true
					}
					if (i === messages.length-1){
						isLastMessage = true;
					}

					var message = messages[i]
					if (message === undefined || (message.type == 'text' && message.text == '')) {
						break;
					}

					var cDate = new Date();
					var cMinute = cDate.getMinutes();
					var cHour = cDate.getHours();

					if (cMinute < 10) {
						cMinute = '0' + cMinute;
					}

					if (cHour < 10) {
						cHour = '0' + cHour;
					}

					$messageContent = Vera.jq('<div class="chatbot-message-content"></div>');
					$quickreplyContent = null;

					var additionalClass = "";
					if(isFirstMessage){
						additionalClass+= "first-message";
					}
					if (isLastMessage){
						additionalClass+= " last-message";
					}
					var $messageElem = Vera.jq('<div class="chatbot-chat-message '+additionalClass+'"></div>');
					switch (message.type) {
						case 'answer':
							var answer = message.payload.global;
							if(historyRegion !== "global" && message.payload[historyRegion] !== undefined){
								answer = message.payload[historyRegion];
							}

							if(message.payload[region] !== undefined){
								answer = message.payload[region];
							}

							if(answer !== undefined){
								switch(answer.type){
									case 'text':
											$messageContent.append(Vera.jq('<p>' + answer.text + '</p>'));
										break;
									case 'html':
											$messageContent.append(Vera.jq(answer.html));
										break;
									case 'quickReply':
										let isList = false;
										quickReply = answer.quickReply;
										if(quickReply.hasOwnProperty('listenansicht')){
											if(quickReply.listenansicht){
												isList = true;
											}
										}else{
											isList = false;
										}
										if(isList){
											$quickreplyList = Vera.jq('<div class="chatbot-action-list"></div>');

											for (var i=0; i<quickReply.options.length; i++) {
												$quickreplyList.append(Vera.jq('<a class="chatbot-action-list-item" href="#" data-query="'+ quickReply.options[i] +'">' + quickReply.options[i] + '</a>'));
											}
											$messageContent.append($quickreplyList);
											$messageElem.addClass("chatbot-response-action-list");
										}else{
											quickReply = answer.quickReply;
											$quickreplyContent = Vera.jq('<div class="chatbot-response-quick-replies"></div>');
											for (var j=0; j<quickReply.options.length; j++) {
												$quickreplyContent.append(Vera.jq('<div class="chatbot-quick-reply"' +((j > 2) && 'style="display:none;"')+ '><a class="chatbot-quick-reply-button" href="#" data-query="'+ quickReply.options[j] +'">' + quickReply.options[j] + '</a></div>'));
												if (j == 2 && quickReply.options.length > 3){
													$quickreplyContent.append(Vera.jq('<div class="chatbot-quick-reply"><a class="chatbot-quick-reply-button chatbot-quick-reply-outline" href="#">Weitere Themen …</a></div>'));
												}
											}

											$messageContent.append(Vera.jq('<p>' + quickReply.title + '</p>'));
											if(quickReply.description){
												$messageContent.append(Vera.jq(quickReply.description));
											}
										}

										break;
									case 'video':
										var youtubeVideoId = Vera.getYoutubeVideoId(answer.video.url);
										var accessibilityText = answer.video.title;
										$messageContent.append(Vera.jq('<p>' + answer.video.title + '</p>'));
										if(answer.video.description){
											$messageContent.append(Vera.jq(answer.video.description));
										}
										$messageContent.append('<iframe src="//www.youtube.com/embed/' + youtubeVideoId + '" title="' + accessibilityText + '" frameborder="0" allowfullscreen></iframe>');
										break;
								}
							}

							break;
						case 'text':
							$messageContent.append(Vera.jq('<p>' + message.text + '</p>'));
							break;
						case 'htmlText':
							$messageContent.append(Vera.jq(message.htmlText));
							break;
						case 'feedback':
							$messageContent.append(Vera.jq(message.feedback));
							break;
						default:
							$messageContent.append('<p>Ich habe leider keine passende Antwort gefunden.</p>');
					}


					if(isUserMessage) {
						$messageContent.append('<div class="chatbot-chat-message-last-row"><div class="chatbot-chat-message-time"><span>' + cHour + ':' + cMinute + '</span></div></div>');
						$messageElem.append($messageContent);
					} else {
						$messageElem.append($messageContent);
					}

					if($messageElem.html() !== '<div class="chatbot-message-content"></div>') {
						$messageContainer.append($messageElem);
					}

					//Quick Reply Buttons ergänzen
					if($quickreplyContent){
						$messageContainer.append($quickreplyContent);
					}

					//Feedback
					let showFeedback = true;
					if(message.hasOwnProperty("payload")){
						let tmpAnswer = message.payload.global;
						if (isCurrent) {
							if (message.payload[region] !== undefined) {
								tmpAnswer = message.payload[region];
							}
						} else {
							if (message.payload[historyRegion] !== undefined) {
								tmpAnswer = message.payload[historyRegion];
							}
						}

						if(tmpAnswer.hasOwnProperty("showFeedback")){
							if(!tmpAnswer.showFeedback){
								showFeedback = false;
							}
						}
					}

					if(!isUserMessage && isLastMessage && id !== null && showFeedback){
						$messageContent.append('<div class="chatbot-chat-message-last-row">' +
							'                    <div class="chatbot-feedback-icons">' +
							'                        <span class="chatbot-feedback-icon-up '+ (feedback === "positiv" ? "active" : "") + (feedback !== "" && feedback !== null ? " disabled" : "") + '" data-id="' + id + '"></span>' +
							'                        <span class="chatbot-feedback-icon-down '+ (feedback === "negativ" ? "active" : "") + (feedback !== "" && feedback !== null ? " disabled" : "") +'" data-id="' + id + '"></span>' +
							'                    </div>' +
							'                    <div class="chatbot-chat-message-time"><span>' + cHour + ':' + cMinute + '</span></div>' +
							'                   </div>');
					}

					if($messageElem.html() !== '<div class="chatbot-message-content"></div>'){
						returnedMessages[i] = $messageElem;
					}
					var $chatBody = Vera.jq('.chatbot-chat-history');
					if (isUserMessage && showAnim) {
						$chatBody.animate({ scrollTop: $chatBody.prop("scrollHeight") }, 200);
					} else if(isUserMessage) {
						$chatBody.scrollTop($chatBody.prop("scrollHeight"));
					}
				}

				if($messageContainer.text().trim()){
					Vera.jq('.chatbot-chat-history').append($messageContainer);
				} else {
					if(isCurrent) {
						var message = {
							'type': 'text',
							'text': 'no_answer'
						}
						Vera.ask(message, 'no_answer');
					}
				}
			}

			return returnedMessages;
		}

		Vera.getYoutubeVideoId = function(url) {
			var regExp = /^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|&v=)([^#&?]*).*/;
			var match = url.match(regExp);

			return (match && match[2].length === 11)
				? match[2]
				: null;
		}

		Vera.updateCsrf = function(message, event) {

			Vera.jq.ajax({
				method: 'GET',
				url: apiUrl + '/refresh-csrf',
				contentType: 'text/html',
				xhrFields: {
					withCredentials: true
				},
				crossDomain: true,
				success: function (data) {
					Vera.jq("input[name=_token]").val(data);
					Vera.jq('[name="csrf_token"]').val(data);
					Vera.ask(message, event, true);
				}
			});
		}

		Vera.getCookie = function(name) {
			var match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
			if (match) return match[2];
		}

		Vera.escapeMessage = function (str) {
			var div = document.createElement('div');
			div.appendChild(document.createTextNode(str));
			return div.innerHTML;
		}


		function loadScript(url, callback) {
			let script = document.createElement('script');
			script.async = true;
			script.src = url;

			let entry = document.getElementById('cb-script');
			entry.parentNode.insertBefore(script, entry);

			script.onload = script.onreadystatechange = function() {
				let rdyState = script.readyState;

				if (!rdyState || /complete|loaded/.test(script.readyState)) {
					callback();

					script.onload = null;
					script.onreadystatechange = null;
				}
			}
		}

		/**
		 * function to load stylesheets
		 * @param url
		 */
		function loadStylesheet(url) {
			let link = document.createElement('link');
			link.rel = 'stylesheet';
			link.type = 'text/css';
			link.href = url;

			let entry = document.getElementsByTagName('script')[0];
			entry.parentNode.insertBefore(link, entry);
		}

		/**
		 * function to check if css is already loaded
		 * @param callback
		 */
		function isCssReady(callback) {
			let testElem = document.createElement('div');
			testElem.id = 'vera-css-ready';
			testElem.style = 'color: #ffffff';

			let entry = document.getElementsByTagName('script')[0];
			entry.parentNode.insertBefore(testElem, entry);

			(function poll() {
				let node = document.getElementById('vera-css-ready');
				let value;

				if (window.getComputedStyle) {
					value = document.defaultView.getComputedStyle(testElem, null).getPropertyValue('color');
				} else if (node.currentStyle) {
					value = node.currentStyle.color;
				}

				if (value && value === 'rgb(186, 218, 85)' || value.toLocaleLowerCase() === '#bada55') {
					callback();
					node.parentNode.removeChild(node);
				} else {
					setTimeout(poll, 500);
				}
			})();
		}

		/**
		 * get src-URL of script, to extract paramter from URL
		 * @returns {string|null}
		 */
		function getScriptUrl() {
			let scripts = document.getElementsByTagName('script');
			let element;
			let src;

			for (let i=0; i<scripts.length; i++) {
				element = scripts[i];
				src = element.src;
				if (src && /(.*)embed\.js/.test(src)) {
					return src;
				}
			}
			return null;
		}

		/**
		 * Extract parameters from url-query-path
		 * @param query
		 */
		function getQueryParams(query) {
			let args = query.split('&');
			let params = {};
			let pair;
			let key;
			let value;

			function decode(string) {
				return decodeURIComponent(string || "").replace('+', ' ');
			}

			for (let i=0; i<args.length; i++) {
				pair = args[i].split('=');
				key = decode(pair[0]);
				value = decode(pair[1]);
				params[key] = value;
			}
			return params;
		}

		function getWidgetParams() {
			let url = getScriptUrl();
			let params = getQueryParams(url.replace(/^.*\?/, ''));
			return params;
		}

		function loadSupportingFiles(callback) {
			callback();
		}

		loadSupportingFiles(function() {
			params = getWidgetParams();

			var curDate = new Date();
			var timestamp = "" + curDate.getFullYear() + (curDate.getMonth() + 1) + curDate.getDate();
			loadStylesheet(baseUrl + '/chat/css/style.css?t=' + timestamp);
			isCssReady(function() {
				setTimeout(function() {
					loadScript(baseUrl + '/chat/js/jquery.embed.min.js', function() {
						Vera.loadChatWindow();
					});
					loadScript(baseUrl + '/chat/js/wavesurfer.embed.min.js', function() {

					});
				}, timeout);
			});
		});

		return Vera;
	})(window);
} else {
	var Vera = window._cb;
}

window._cb = Vera;